#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_VbecsVersion : BaseTest 
	{

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			//Clear out all records
			UnitTestUtil.RunSQL("DELETE FROM VbecsVersion");
            UnitTestUtil.RunSQL("DELETE FROM VbecsDBRevision");
		}

		[Test]
		public void CurrentVersion_Pass()
		{
			//VbecsVersion is a static variable, so have to check pass/failure conditions here, starting with failure...
			Assert.AreEqual("NOT FOUND", BOL.VbecsVersion.CurrentVersion, "No Records");

			//By default, UnitTests kill VbecsVersion, so we put one in there, plus I kill it in SetUp now
			string randomNumber = DateTime.Now.Ticks.ToString();
			UnitTestUtil.RunSQL("INSERT INTO VbecsVersion (Version, PatchSuccessfulIndicator, LastUpdateDate, LastUpdateUser, LastUpdateFunctionId) VALUES ('" + randomNumber + "', 1, GETUTCDATE(), '" + Common.LogonUser.LogonUserName + "', 9999)"); 

			string tstValue = BOL.VbecsVersion.CurrentVersion;
			Assert.AreEqual(BOL.VbecsVersion.CurrentVersion, tstValue, "Manual Record");

			UnitTestUtil.RunSQL("DELETE FROM VbecsVersion");
			//WE delete the reocrd and the app still shows the value
			Assert.AreEqual(BOL.VbecsVersion.CurrentVersion, tstValue, "Static Check After Table Wipe");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CurrentVersion_Fail()
		{
		}
        [Test]
        public void CurrentRevision_Pass()
        {
            //VbecsRevision is a static variable, so have to check pass/failure conditions here, starting with failure...
            Assert.AreEqual("NOT FOUND", BOL.VbecsVersion.CurrentRevision, "No Records");

            //By default, UnitTests kill VbecsDBRevision, so we put one in there, plus I kill it in SetUp now
        
            string randomNumber = DateTime.Now.Ticks.ToString();
            
            UnitTestUtil.RunSQL("INSERT INTO VbecsDBRevision (VbecsVersion, Revision, Comment, LastUpdateDate, LastUpdateUser) VALUES ('" + randomNumber + "', 'C' , '' ,  GETUTCDATE(), '" + Common.LogonUser.LogonUserName + "')");

            string tstValue = BOL.VbecsVersion.CurrentRevision;
            Assert.AreEqual(BOL.VbecsVersion.CurrentRevision, tstValue, "Manual Record");

            UnitTestUtil.RunSQL("DELETE FROM VbecsDBRevision");
            //WE delete the reocrd and the app still shows the value
            Assert.AreEqual(BOL.VbecsVersion.CurrentRevision, "NOT FOUND", "Static Check After Table Wipe");
        }

        [Test]
        [Ignore(StandardIgnoreReasons.NoFailureConditions)]
        public void CurrentRevision_Fail()
        {
        }
	}
}
#endif


